import tkinter as tk
import subprocess

ascii_art = [
    "  ___        ___  _____ ",
    " / _ \\__  __/ _ \\|  ___|",
    "| | | \\ \\/ / | | | |_   ",
    "| || |>  <| || |  _|   ",
    " \\///\\\\\\/|_|          "
]

start_message = "Нажмите Enter чтобы начать"

class HackerGameIntro:
    def __init__(self):
        self.root = tk.Tk()
        self.root.configure(bg="black")
        self.root.attributes('-fullscreen', True)

        self.canvas = tk.Canvas(self.root, bg="black", highlightthickness=0)
        self.canvas.pack(fill=tk.BOTH, expand=True)

        self.root.bind("<Return>", self.on_enter)

        self.current_line = 0
        self.current_char = 0
        self.text_objects = []

        self.root.after(100, self.prepare_canvas_and_start)

        self.root.mainloop()

    def prepare_canvas_and_start(self):
        self.canvas.delete("all")
        self.canvas.update()

        self.center_x = self.canvas.winfo_width() // 2
        self.center_y = self.canvas.winfo_height() // 2

        self.line_height = 30
        self.start_y = self.center_y - (len(ascii_art) * self.line_height) // 2
        self.lines_to_draw = [''] * len(ascii_art)

        self.animate_ascii()

    def animate_ascii(self):
        if self.current_line < len(ascii_art):
            full_line = ascii_art[self.current_line]
            if self.current_char < len(full_line):
                self.lines_to_draw[self.current_line] += full_line[self.current_char]
                self.draw_line(self.current_line, self.lines_to_draw[self.current_line])
                self.current_char += 1
                self.root.after(20, self.animate_ascii)
            else:
                self.current_line += 1
                self.current_char = 0
                self.root.after(100, self.animate_ascii)
        else:
            self.canvas.create_text(
                self.center_x, 
                self.start_y + len(ascii_art) * self.line_height + 50,
                text=start_message,
                fill="lime",
                font=("Courier", 20),
                anchor="center"
            )

    def draw_line(self, line_index, text):
        if line_index < len(self.text_objects):
            if self.text_objects[line_index]:
                self.canvas.delete(self.text_objects[line_index])

        y = self.start_y + line_index * self.line_height
        text_id = self.canvas.create_text(
            self.center_x, y,
            text=text,
            fill="lime",
            font=("Courier", 24),
            anchor="center"
        )

        if line_index >= len(self.text_objects):
            self.text_objects.append(text_id)
        else:
            self.text_objects[line_index] = text_id

    def on_enter(self, event):
        self.root.destroy()
        subprocess.Popen(['python', 'sim.py'])

if __name__ == "__main__":
    HackerGameIntro()
