import re

# Цвета для тегов
KEYWORD_COLOR = "lime"  # кислотно-зеленый
VAR_COLOR = "red"
WAIT_COLOR = "#006400"  # темно-зеленый

DEFAULT_KEYWORDS = ["create", "make", "set", "smell"]

def setup_tags(text_widget):
    # Настраиваем теги с цветами
    text_widget.tag_config("keyword", foreground=KEYWORD_COLOR)
    text_widget.tag_config("varname", foreground=VAR_COLOR)
    text_widget.tag_config("wait", foreground=WAIT_COLOR)

def apply_highlighting(text_widget):
    # Очищаем старые теги
    text_widget.tag_remove("keyword", "1.0", "end")
    text_widget.tag_remove("varname", "1.0", "end")
    text_widget.tag_remove("wait", "1.0", "end")

    text = text_widget.get("1.0", "end-1c")
    lines = text.split("\n")

    for lineno, line in enumerate(lines, start=1):
        # Поиск ключевых слов create, make, set, smell
        for kw in DEFAULT_KEYWORDS:
            for match in re.finditer(rf"\b{kw}\b", line):
                start_index = f"{lineno}.{match.start()}"
                end_index = f"{lineno}.{match.end()}"
                text_widget.tag_add("keyword", start_index, end_index)

        # Подсветка имени переменной после create или make
        match_var = re.search(r"\b(create|make)\s+(\w+)\s+set\b", line)
        if match_var:
            varname = match_var.group(2)
            start_pos = match_var.start(2)
            end_pos = start_pos + len(varname)
            start_index = f"{lineno}.{start_pos}"
            end_index = f"{lineno}.{end_pos}"
            text_widget.tag_add("varname", start_index, end_index)

        # Подсветка команды wait темно-зеленым
        for match in re.finditer(r"\bwait\b", line):
            start_index = f"{lineno}.{match.start()}"
            end_index = f"{lineno}.{match.end()}"
            text_widget.tag_add("wait", start_index, end_index)
