def interpret_bebra_generator(code, log=None, show_popup=None):
    import re
    lines = code.strip().split('\n')
    for line_no, line in enumerate(lines, start=1):
        line = line.strip()
        if not line:
            continue

        # Разбор команды smell
        m = re.match(r'smell\(\s*(text|numb)\s*,\s*(.+?)\s*,\s*(console|screen)\s*\)', line)
        if m:
            val_type, value, target = m.groups()
            # если value в кавычках — уберем кавычки, иначе оставим
            if value.startswith('"') and value.endswith('"'):
                value = value[1:-1]

            # Выводим по месту назначения
            if target == "console" and log:
                log(str(value))
            elif target == "screen" and show_popup:
                show_popup(str(value))

            yield ("continue", None)
            continue

        # Разбор команды wait
        m = re.match(r'wait\(\s*(sec|min)\s+(\d+)\s*\)', line)
        if m:
            unit, amount = m.groups()
            amount = int(amount)
            seconds = amount if unit == "sec" else amount * 60
            yield ("wait", seconds)
            yield ("continue", None)
            continue

        # Прочие команды пока просто логируем
        if log:
            log(f"Выполняю строку {line_no}: {line}")

        yield ("continue", None)

    yield ("done", None)
