class CreateCommand:
    def __init__(self, var_name, value):
        self.var_name = var_name
        self.value = value
    def __repr__(self):
        return f"Create({self.var_name} = {self.value})"

class MakeCommand:
    def __init__(self, var_name, value):
        self.var_name = var_name
        self.value = value
    def __repr__(self):
        return f"Make({self.var_name} = {self.value})"

class SmellCommand:
    def __init__(self, val_type, var_name, output):
        self.val_type = val_type
        self.var_name = var_name
        self.output = output
    def __repr__(self):
        return f"Smell({self.val_type}, {self.var_name}, {self.output})"

class WaitCommand:
    def __init__(self, unit, amount):
        self.unit = unit
        self.amount = amount
    def __repr__(self):
        return f"Wait({self.amount} {self.unit})"
    
class FuncDefCommand:
    def __init__(self, name, args, body=None):
        self.name = name
        self.args = args
        self.body = body or []
    def __repr__(self):
        return f'FuncDef({self.name}({', '.join(self.args)}): {self.body})'
    
class FuncCallCommand:
    def __init__(self, name, args):
        self.name = name
        self.args = args
    def __repr__(self):
        return f"FuncCall({self.name}({', '.join(self.args)}))"
    
